(function (blocks, element, i18n, components, blockEditor) {
	const { registerBlockType } = blocks;
	const { createElement: el } = element;
	const { __ } = i18n;
	const { TextControl, PanelBody } = components;
	const { InspectorControls } = blockEditor;

	registerBlockType('kokovoice/form', {
		edit(props) {
			const { attributes, setAttributes } = props;
			const { buttonLabel = __( 'Generate Voice', 'kokovoice' ), defaultVoice = '', defaultSpeed = '' } = attributes;

			return [
				el(
					InspectorControls,
					null,
					el(
						PanelBody,
						{ title: __( 'Form defaults', 'kokovoice' ), initialOpen: true },
						el( TextControl, {
							label: __( 'Button label', 'kokovoice' ),
							value: buttonLabel,
							onChange: ( value ) => setAttributes( { buttonLabel: value } ),
						} ),
						el( TextControl, {
							label: __( 'Default voice formula', 'kokovoice' ),
							help: __( 'Optional voice formula to pre-fill (e.g. af_alloy).', 'kokovoice' ),
							value: defaultVoice,
							onChange: ( value ) => setAttributes( { defaultVoice: value } ),
						} ),
						el( TextControl, {
							label: __( 'Default speed', 'kokovoice' ),
							help: __( 'Number between 0.1 and 2.0 (inclusive).', 'kokovoice' ),
							value: defaultSpeed,
							onChange: ( value ) => setAttributes( { defaultSpeed: value } ),
						} ),
					)
				),
			];

			return el(
				'div',
				{ className: 'kokovoice-block-preview' },
				el('p', { className: 'kokovoice-block-preview__label' }, __( 'Kokoro Voice Form (preview)', 'kokovoice' )),
				el('p', null, __( 'The full form will render on the front end.', 'kokovoice' )),
				el('p', null, `${__( 'Button label:', 'kokovoice' )} ${buttonLabel || __( 'Generate Voice', 'kokovoice' )}`)
			);
		},
		save() {
			return null;
		},
	});
})(window.wp.blocks, window.wp.element, window.wp.i18n, window.wp.components, window.wp.blockEditor || window.wp.editor);
