# Kokovoice WordPress Plugin

Convert text to speech using Kokoro AI - works for all visitors!

## Features

✅ **53 Voices in 7 Languages** - English (US/GB), Spanish, Japanese, Chinese, Hindi, Italian, Portuguese  
✅ **Public Access** - No WordPress login required  
✅ **OpenAI-Compatible API** - Easy integration  
✅ **Speed Control** - Adjust speech speed (0.1x to 2x)  
✅ **Shortcode Support** - `[kokoro_voice_form]`  
✅ **Gutenberg Block** - Use in block editor  
✅ **Debug Mode** - Built-in troubleshooting  

## Installation

1. Download `kokovoice.zip`
2. In WordPress Admin: Plugins → Add New → Upload Plugin
3. Choose the ZIP file and click "Install Now"
4. Activate the plugin
5. Go to Settings → Kokovoice to configure

## Configuration

### Required Settings
- **API URL**: `https://kokoro.lancesmith.cc` (or your API endpoint)
- **API Key**: Optional - leave blank for public access

### Optional Settings
- **Default Voice**: Choose from 40+ available voices
- **Default Speed**: Set default playback speed (0.5 to 2.0)
- **Model**: Choose AI model (default: model_q8f16)

## Usage

### Basic Shortcode
```
[kokoro_voice_form]
```

### With Custom Settings
```
[kokoro_voice_form voice="af_alloy" speed="1.2"]
```

### Debug Mode
```
[kokoro_voice_form debug="true"]
```
This will show detailed console logs for troubleshooting. Open browser console (F12) to see debug messages.

### Gutenberg Block
1. Add new block
2. Search for "Kokovoice"
3. Configure options in block settings

## Available Voices (53 Total)

### English (US) - 20 voices
**Female:** Heart (Best Quality), Bella, Nicole, Sarah, Aoede, Kore, Alloy, Nova, Sky, Jessica, River  
**Male:** Fenrir, Michael, Puck, Echo, Eric, Liam, Onyx, Santa, Adam

### English (British) - 8 voices
**Female:** Emma, Isabella, Alice, Lily  
**Male:** George, Fable, Lewis, Daniel

### Spanish - 3 voices
**Female:** Dora  
**Male:** Alex, Santa

### Japanese - 5 voices
**Female:** Alpha, Gongitsune, Tebukuro, Nezumi  
**Male:** Kumo

### Chinese (Mandarin) - 8 voices
**Female:** Xiaobei, Xiaoni, Xiaoxiao, Xiaoyi  
**Male:** Yunjian, Yunxi, Yunxia, Yunyang

### Hindi - 4 voices
**Female:** Alpha, Beta  
**Male:** Omega, Psi

### Italian - 2 voices
**Female:** Sara  
**Male:** Nicola

### Portuguese - 3 voices
**Female:** Dora  
**Male:** Alex, Santa

## Debug Mode

When you add `debug="true"` to your shortcode, the plugin will log detailed information to the browser console:

1. **Request Details**: Payload, API URL, headers
2. **Response Status**: HTTP status codes
3. **Error Messages**: Detailed error information
4. **Audio Generation**: File sizes, playback status

### How to Use Debug Mode:

1. Add the debug shortcode: `[kokoro_voice_form debug="true"]`
2. Open browser developer tools (F12)
3. Go to Console tab
4. Try generating audio
5. Look for messages starting with `[Kokovoice Debug]`

## Troubleshooting

### "Sorry, you are not allowed" Error
This plugin is designed for public access. Make sure you're using version 0.3.2 or later, which has this issue fixed.

### Audio Not Playing
- Check browser console for errors (F12)
- Enable debug mode to see detailed logs
- Verify API URL is correct in settings
- Check that the API endpoint is accessible

### Slow Generation
- Try a faster model in settings
- Check your server/API response time
- Consider adding a CDN for API requests

## API Key (Optional)

API keys are **optional** for this plugin. It works without authentication.

If you want to use an API key:
1. Get your key from your Kokoro API provider
2. Enter it in Settings → Kokovoice → API Key field
3. Format: `kw_your_key_here`

## Security Notes

⚠️ **Public Access**: This plugin allows anyone to generate audio without logging in to WordPress.

**Recommendations for production sites:**
- Add rate limiting to prevent abuse
- Monitor API usage
- Consider adding CAPTCHA for high-traffic sites
- Review WordPress security best practices

## Support

- **Plugin Issues**: Check debug mode console logs
- **API Issues**: Visit [Kokoro API Docs](https://kokoro.lancesmith.cc/developers)
- **WordPress Help**: WordPress support forums

## Version History

### 0.3.3 (Current)
- Added all 53 Kokoro voices (previously only 6)
- Organized voices by language
- Added gender labels for all voices
- Added language indicators (US, GB, Spanish, Japanese, Chinese, Hindi, Italian, Portuguese)

### 0.3.2
- Added optional debug mode via shortcode attribute
- Improved error messages
- Fixed public access authentication issues
- Enhanced logging for troubleshooting

### 0.3.1
- Fixed "Sorry, you are not allowed" error
- Improved public access support

### 0.3.0
- Initial public release
- Public access support
- OpenAI-compatible API integration

## License

GPLv2 or later

## Credits

Built for [Kokoro Text-to-Speech](https://kokoro.lancesmith.cc)  
Powered by Kokoro 82M AI model

