# Kokoreader WordPress Plugin

Floating "Speak" button that reads selected text aloud using Kokoro AI.

## Features

✅ **Floating Speak Button** - Small, unobtrusive button on every page  
✅ **Reads Selected Text** - Only reads what the user selects  
✅ **53 Voices** - Choose from 53 AI voices in 7 languages  
✅ **Site-Wide** - Works on all pages when enabled  
✅ **Customizable** - Configure voice, speed, and button position  
✅ **No Login Required** - Works for all visitors  

## Installation

1. Download `kokoreader.zip`
2. WordPress Admin → Plugins → Add New → Upload Plugin
3. Choose `kokoreader.zip` and click "Install Now"
4. Activate the plugin
5. Go to Settings → Kokoreader

## Configuration

### Settings → Kokoreader

1. **Enable Reader** - Turn the floating button on/off
2. **Voice** - Choose from 53 voices:
   - English (US/British)
   - Spanish
   - Japanese
   - Chinese
   - Hindi
   - Italian
   - Portuguese
3. **Speed** - Adjust playback speed (0.5x to 2.0x)
4. **Button Position** - Choose corner placement:
   - Bottom Right (default)
   - Bottom Left
   - Top Right
   - Top Left

## How to Use

### For Site Administrators:
1. Go to Settings → Kokoreader
2. Check "Enable Reader"
3. Select your preferred voice
4. Set the speech speed
5. Choose button position
6. Click "Save Changes"

### For Site Visitors:
1. Visit any page on the site
2. Select any text on the page
3. Click the floating "Speak" button
4. Listen to the selected text being read aloud!

## Available Voices (53 Total)

### English (US) - 20 voices
**Female:** Heart (Best Quality), Bella, Nicole, Sarah, Aoede, Kore, Alloy, Nova, Sky, Jessica, River  
**Male:** Fenrir, Michael, Puck, Echo, Eric, Liam, Onyx, Santa, Adam

### English (British) - 8 voices
**Female:** Emma, Isabella, Alice, Lily  
**Male:** George, Fable, Lewis, Daniel

### Spanish - 3 voices
**Female:** Dora  
**Male:** Alex, Santa

### Japanese - 5 voices
**Female:** Alpha, Gongitsune, Tebukuro, Nezumi  
**Male:** Kumo

### Chinese (Mandarin) - 8 voices
**Female:** Xiaobei, Xiaoni, Xiaoxiao, Xiaoyi  
**Male:** Yunjian, Yunxi, Yunxia, Yunyang

### Hindi - 4 voices
**Female:** Alpha, Beta  
**Male:** Omega, Psi

### Italian - 2 voices
**Female:** Sara  
**Male:** Nicola

### Portuguese - 3 voices
**Female:** Dora  
**Male:** Alex, Santa

## Features in Detail

### Selection-Based Reading
- Only reads text that the user actively selects
- No automatic page reading
- User has full control over what gets read

### Floating Button
- Always accessible in chosen corner
- Responsive design for mobile devices
- Visual feedback on hover/click
- Disabled state when no text is selected

### Smart Text Handling
- Automatically trims whitespace
- Maximum 5000 characters per selection
- Handles special characters and punctuation
- Works with any language text

## Technical Details

- **API:** Kokoro Text-to-Speech API
- **Format:** MP3 audio
- **Response Time:** Typically 1-3 seconds
- **Browser Support:** All modern browsers
- **Mobile:** Fully responsive

## Troubleshooting

### Button not appearing?
- Check Settings → Kokoreader → Enable Reader is checked
- Clear browser cache
- Check browser console for errors (F12)

### No audio playing?
- Make sure text is selected before clicking
- Check browser allows audio autoplay
- Try clicking "Speak" button twice
- Check browser console for errors

### Audio quality issues?
- Try different voices in Settings
- Heart (US Female) is highest quality
- Adjust speed if too fast/slow

## Privacy & Performance

✅ **No Data Storage** - Text is processed in real-time only  
✅ **Public Access** - No user accounts or login required  
✅ **Fast Processing** - Typically 1-3 seconds per request  
✅ **Lightweight** - Minimal impact on page load  

## Support

- **API Issues:** [Kokoro API Docs](https://kokoro.lancesmith.cc/developers)
- **Plugin Issues:** Check browser console for errors
- **WordPress Help:** WordPress support forums

## Version History

### 1.0.0 (Current)
- Initial release
- 53 voices across 7 languages
- Floating button with 4 position options
- Selection-based text reading
- Customizable speed control
- Mobile responsive design

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- Modern web browser

## License

GPLv2 or later

## Credits

Built for [Kokoro Text-to-Speech](https://kokoro.lancesmith.cc)  
Powered by Kokoro 82M AI model

